/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8285.DeviceView;

import ibm.nways.jdm.common.OID;
import ibm.nways.jdm8285.DeviceView.BankLike;
import ibm.nways.jdm8285.DeviceView.Bank_E1;
import ibm.nways.jdm8285.DeviceView.BayLike;
import ibm.nways.jdm8285.DeviceView.Bay_Unknown;
import ibm.nways.jdm8285.DeviceView.Chassis8285;
import ibm.nways.jdm8285.DeviceView.Chassis8285Expansion;
import ibm.nways.jdm8285.DeviceView.ChassisInfoLike;
import ibm.nways.jdm8285.DeviceView.ChassisLike;
import ibm.nways.jdm8285.DeviceView.ChassisUnknown;
import ibm.nways.jdm8285.DeviceView.FactoryLike;
import ibm.nways.jdm8285.DeviceView.ModuleLike;
import ibm.nways.jdm8285.DeviceView.ModuleUnknown;
import ibm.nways.jdm8285.DeviceView.PortATM;
import ibm.nways.jdm8285.DeviceView.PortATM8281;
import ibm.nways.jdm8285.DeviceView.PortAceE1T1;
import ibm.nways.jdm8285.DeviceView.PortLike;
import ibm.nways.jdm8285.DeviceView.PortVDM;
import ibm.nways.ras.RAS;
import java.io.Serializable;

public class Factory
implements FactoryLike {
    private static final FactoryLike instance = new Factory();

    private Factory() {
    }

    public static FactoryLike getInstance() {
        return instance;
    }

    public ChassisLike createChassis(Serializable serializable) {
        String string;
        if (serializable instanceof OID && (string = serializable.toString()).equals("1.3.6.1.4.1.2.6.33.2.2")) {
            return new Chassis8285();
        }
        return new ChassisUnknown();
    }

    public ChassisLike createChassisExpansion() {
        return new Chassis8285Expansion();
    }

    public ModuleLike createModule(ChassisInfoLike chassisInfoLike, int n, int n2) {
        String string = "ibm.nways.jdm8285.DeviceView.Module_";
        try {
            switch (n2) {
                case 2: 
                case 9: 
                case 53: 
                case 54: 
                case 57: 
                case 58: 
                case 60: 
                case 61: 
                case 62: {
                    string = String.valueOf(string) + "NotSupported";
                    break;
                }
                default: {
                    string = String.valueOf(string) + n2;
                }
            }
            if (RAS.isEnabled(19, 6)) {
                RAS.trace(19, 6, this, "createModule", "Creating module class -> " + string + ", slot:" + n);
            }
            Class<?> clazz = Class.forName(string);
            return (ModuleLike)clazz.newInstance();
        }
        catch (Exception exception) {
            RAS.logException(19, 6, this, "createModule", exception);
            if (RAS.isEnabled(19, 6)) {
                RAS.trace(19, 6, this, "createModule", "Creating module class ModuleUnknown, slot:" + n);
            }
            return new ModuleUnknown();
        }
    }

    public PortLike createPort(int n) {
        switch (n) {
            case 56: {
                return new PortVDM();
            }
            case 51: {
                return new PortATM8281();
            }
            case 59: {
                return new PortAceE1T1();
            }
        }
        return new PortATM();
    }

    public BankLike createBank(int n) {
        switch (n) {
            case 2: {
                return new Bank_E1();
            }
        }
        throw new IllegalArgumentException("Unsupported number of ports for bank: " + n);
    }

    public BayLike createBay(int n, int n2) {
        String string = "createBay";
        String string2 = "ibm.nways.jdm8285.DeviceView.Bay_" + n2;
        try {
            if (RAS.isEnabled(19, 6)) {
                RAS.trace(19, 6, this, string, "Creating bay class -> " + string2);
            }
            Class<?> clazz = Class.forName(string2);
            return (BayLike)clazz.newInstance();
        }
        catch (Exception exception) {
            RAS.logException(19, 6, this, string, exception);
            return new Bay_Unknown();
        }
    }
}

